package it.eng.eremita.jpa.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import io.leangen.graphql.annotations.GraphQLQuery;
import it.eng.eremita.graphql.types.Identifiable;
import it.eng.eremita.graphql.types.Trackable;

@Entity
@Table(name="EREMITA_SEGNALAZIONE")
@SequenceGenerator(name="SEQ_SEGNALAZIONE", sequenceName="SEQ_SEGNALAZIONE", initialValue=1, allocationSize=1)
public class Segnalazione implements Serializable, Identifiable<Long>, Trackable<Utente,Long>{
	
	Long id;
	MonitoraggioSpecie monitoraggioSpecie;
	HabitatSpecie tipoHabitat;
	String idHabitat;
	StadioSviluppo stadioSviluppo;
	BigDecimal esemplariM;
	BigDecimal esemplariF;
	BigDecimal esemplariMF;
	BigDecimal coordinataX;
	BigDecimal coordinataY;
	TipoReperto tipoReperto;
	Marcatura marcatura;
	Marcatura marcaturaRicattura;
	
	TipoMarcatura tipoMarcatura;
	String idMarcatura;
	TipoMarcatura tipoRicattura;
	String idRicattura;
	
	String foto;
	String note;
	
	Utente utenteCreazione;
	Utente utenteModifica;
	Date dataCreazione;
	Date dataModifica;
	
	@Id
	@GeneratedValue(strategy=GenerationType.SEQUENCE,generator="SEQ_SEGNALAZIONE")
	@Column(name="ID")
	@GraphQLQuery(name="id")
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	
	@ManyToOne
	@JoinColumn(name="MONITORAGGIO_SPECIE")
	@GraphQLQuery(name="monitoraggioSpecie")
	public MonitoraggioSpecie getMonitoraggioSpecie() {
		return monitoraggioSpecie;
	}
	public void setMonitoraggioSpecie(MonitoraggioSpecie monitoraggioSpecie) {
		this.monitoraggioSpecie = monitoraggioSpecie;
	}
	
	@ManyToOne
	@JoinColumn(name="TIPO_HABITAT")
	@GraphQLQuery(name="tipoHabitat",description="Menu, la lista dei valori possibili si ottiene con {habitatSpecies}")
	public HabitatSpecie getTipoHabitat() {
		return tipoHabitat;
	}
	public void setTipoHabitat(HabitatSpecie tipoHabitat) {
		this.tipoHabitat = tipoHabitat;
	}
	
	@Column(name="HABITAT")
	@GraphQLQuery(name="idHabitat",description="Valore inserito dall'utente")
	public String getIdHabitat() {
		return idHabitat;
	}
	public void setIdHabitat(String idHabitat) {
		this.idHabitat = idHabitat;
	}
	
	@ManyToOne
	@JoinColumn(name="STADIO_SVILUPPO")
	@GraphQLQuery(name="stadioSviluppo",description="Menu, la lista dei valori possibili si ottiene con {stadioSviluppos}")
	public StadioSviluppo getStadioSviluppo() {
		return stadioSviluppo;
	}
	public void setStadioSviluppo(StadioSviluppo stadioSviluppo) {
		this.stadioSviluppo = stadioSviluppo;
	}
	
	@Column(name="FOTO")
	@GraphQLQuery(name="foto")
	public String getFoto() {
		return foto;
	}

	public void setFoto(String foto) {
		this.foto = foto;
	}
	
	@Column(name="NOTE")
	@GraphQLQuery(name="note")
	public String getNote() {
		return note;
	}
	public void setNote(String note) {
		this.note = note;
	}
	@Column(name="ESEMPLARI_M")
	@GraphQLQuery(name="esemplariM")
	public BigDecimal getEsemplariM() {
		return esemplariM;
	}
	public void setEsemplariM(BigDecimal esemplariM) {
		this.esemplariM = esemplariM;
	}
	
	@Column(name="ESEMPLARI_F")
	@GraphQLQuery(name="esemplariF")
	public BigDecimal getEsemplariF() {
		return esemplariF;
	}
	public void setEsemplariF(BigDecimal esemplariF) {
		this.esemplariF = esemplariF;
	}
	
	@Column(name="ESEMPLARI_MF")
	@GraphQLQuery(name="esemplariMF")
	public BigDecimal getEsemplariMF() {
		return esemplariMF;
	}
	public void setEsemplariMF(BigDecimal esemplariMF) {
		this.esemplariMF = esemplariMF;
	}
	
	@Column(name="COORDINATA_X",precision=8,scale=6)
	@GraphQLQuery(name="coordinataX")
	public BigDecimal getCoordinataX() {
		return coordinataX;
	}
	public void setCoordinataX(BigDecimal coordinataX) {
		this.coordinataX = coordinataX;
	}
	
	@Column(name="COORDINATA_Y",precision=8,scale=6)
	@GraphQLQuery(name="coordinataY")
	public BigDecimal getCoordinataY() {
		return coordinataY;
	}
	public void setCoordinataY(BigDecimal coordinataY) {
		this.coordinataY = coordinataY;
	}
	
	@ManyToOne
	@JoinColumn(name="TIPO_REPERTO")
	@GraphQLQuery(name="tipoReperto",description="Menu, la lista dei valori possibili si ottiene con {tipoRepertos}")
	public TipoReperto getTipoReperto() {
		return tipoReperto;
	}
	public void setTipoReperto(TipoReperto tipoReperto) {
		this.tipoReperto = tipoReperto;
	}
	
	@ManyToOne(cascade=CascadeType.ALL)
	@JoinColumn(name="MARCATURA")
	@GraphQLQuery(name="marcatura")
	public Marcatura getMarcatura() {
		return marcatura;
	}
	public void setMarcatura(Marcatura marcatura) {
		this.marcatura = marcatura;
	}
	
	@OneToOne(cascade=CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="MARCATURA_RICATTURA")
	@GraphQLQuery(name="marcaturaRicattura")
	public Marcatura getMarcaturaRicattura() {
		return marcaturaRicattura;
	}
	public void setMarcaturaRicattura(Marcatura marcaturaRicattura) {
		this.marcaturaRicattura = marcaturaRicattura;
	}
	
	
	@ManyToOne
	@JoinColumn(name="TIPO_MARCATURA")
	@GraphQLQuery(name="tipoMarcatura")
	public TipoMarcatura getTipoMarcatura() {
		return tipoMarcatura;
	}
	public void setTipoMarcatura(TipoMarcatura tipoMarcatura) {
		this.tipoMarcatura = tipoMarcatura;
	}
	@Column(name="ID_MARCATURA")
	@GraphQLQuery(name="idMarcatura")
	public String getIdMarcatura() {
		return idMarcatura;
	}
	public void setIdMarcatura(String idMarcatura) {
		this.idMarcatura = idMarcatura;
	}
	@ManyToOne
	@JoinColumn(name="TIPO_RICATTURA")
	@GraphQLQuery(name="tipoRicattura")
	public TipoMarcatura getTipoRicattura() {
		return tipoRicattura;
	}
	public void setTipoRicattura(TipoMarcatura tipoRicattura) {
		this.tipoRicattura = tipoRicattura;
	}
	@Column(name="ID_RICATTURA")
	@GraphQLQuery(name="idRicattura")
	public String getIdRicattura() {
		return idRicattura;
	}
	public void setIdRicattura(String idRicattura) {
		this.idRicattura = idRicattura;
	}
	@ManyToOne
	@JoinColumn(name="UTENTE_CREAZIONE")
	@GraphQLQuery(name="utenteCreazione")
	public Utente getUtenteCreazione() {
		return utenteCreazione;
	}

	public void setUtenteCreazione(Utente utenteCreazione) {
		this.utenteCreazione = utenteCreazione;
	}

	@ManyToOne
	@JoinColumn(name="UTENTE_MODIFICA")
	@GraphQLQuery(name="utenteModifica")
	public Utente getUtenteModifica() {
		return utenteModifica;
	}

	public void setUtenteModifica(Utente utenteModifica) {
		this.utenteModifica = utenteModifica;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="DATA_CREAZIONE")
	@GraphQLQuery(name="dataCreazione")
	public Date getDataCreazione() {
		return dataCreazione;
	}

	public void setDataCreazione(Date dataCreazione) {
		this.dataCreazione = dataCreazione;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="DATA_MODIFICA")
	@GraphQLQuery(name="dataModifica")
	public Date getDataModifica() {
		return dataModifica;
	}

	public void setDataModifica(Date dataModifica) {
		this.dataModifica = dataModifica;
	}
	
	
	public boolean equals(Object o) {
		if (o==null) return false;
		
		if (!(o instanceof Segnalazione)) return false;
		
		Segnalazione ms = (Segnalazione)o;
		return (ms.getId()==this.getId());

	}
	
	@Override
	public String toString() {
		return "Segnalazione-"+getId();
	}
	
	@Override
	public int hashCode() {
		return (int)( getId()%Integer.MAX_VALUE);
	}
	
	

}
